
package lrs.visitor;
import counter.*;
import lrs.*;

/**
* Returns the nth element in a LRS.
*/
public class Nth implements IAlgo, ICounterAlgo
{
 public static Nth Singleton = new Nth(); 
 private Nth()
 {
 }

 /**
  * @param host 
  * @param param 
  * @return 
  */
 public Object nullCase(LRStruct host, Object param)
 {
  return (null); // No such element exists
 }

 /**
  * @param host 
  * @param param 
  * @return 
  */
 public Object nonNullCase(LRStruct host, Object param)
 {
  return (((Counter) param).execute(this, host)); //
 }

 /**
  * @param host counter to be operated on
  * @param param LRS to be operated on
   * @return the first element.
  */
 public Object zeroCase(Counter host, Object param)
 {
  // param is the host of the null/nonNull cases.
  return (((LRStruct)param).getFirst ());
 }

 /**
  * @param host 
  * @param param 
  * @return 
  */
 public Object nonZeroCase(Counter host, Object param)
 {
  return (((LRStruct) param).getRest ().execute (this, host.decrement ()));
 }


}

